/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.handler;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.search.ExternalReference;
import com.aptana.editor.php.internal.search.IElementNode;
import com.aptana.editor.php.internal.ui.dialog.ElementSelectionDialog;
import com.aptana.editor.php.internal.ui.handler.Messages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTypeHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object[] result;
        ElementSelectionDialog typeSelectionDialog = new ElementSelectionDialog(Display.getCurrent().getActiveShell(), false);
        typeSelectionDialog.setTitle(Messages.OpenTypeHandler_openTypeTitle);
        typeSelectionDialog.setMessage(Messages.OpenTypeHandler_openTypeMessage);
        int open = typeSelectionDialog.open();
        if (open == 0 && (result = typeSelectionDialog.getResult()).length > 0) {
            IElementNode node = (IElementNode)result[0];
            ExternalReference externalReference = node.toExternalReference();
            if (externalReference.editorInput != null) {
                try {
                    IEditorDescriptor editorDescriptor = IDE.getEditorDescriptor((String)externalReference.editorInput.getName());
                    String editorId = editorDescriptor.getId();
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)externalReference.editorInput, (String)editorId);
                    if (openEditor instanceof ITextEditor) {
                        ITextEditor ed = (ITextEditor)openEditor;
                        int position = externalReference.position.getStartingOffset();
                        ed.selectAndReveal(position, 0);
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }
}

